<?php

include("db.php");



// Start the session

session_start();



// Set headers for API response

header('Content-Type: application/json');

header("Access-Control-Allow-Origin: *");

header("Access-Control-Allow-Methods: GET, OPTIONS");

header("Access-Control-Allow-Headers: Content-Type, Authorization");

header("Access-Control-Allow-Credentials: true");



// Enable error reporting for debugging

error_reporting(E_ALL);

ini_set('display_errors', 1);



if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    // Check if user data exists in session

    if (isset($_SESSION['user'])) {

        // Return complete user data from session

        echo json_encode([

            'status' => 'success',

            'message' => 'User data retrieved',

            'data' => $_SESSION['user']

        ]);

    } else {

        // No user data in session

        echo json_encode([

            'status' => 'error',

            'message' => 'No user data found in session'

        ]);

    }

} else {

    // Invalid request method

    echo json_encode([

        'status' => 'error',

        'message' => 'Only GET method is allowed'

    ]);

}

?>